%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Beamer theme for Cr@ns (http://www.crans.org) presentations    %
%                                                                %
% This is a basic theme for beamer presentations designed        %
%   for lectures given by Cr@ns members                          %
%                                                                %
% Author : Xavier Lagorce <Xavier.Lagorce@crans.org>             %
% Copyright 2010                                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{crans-beamer}[26/09/2010, v1.0]

\LoadClass{beamer}

\RequirePackage{graphicx}

% Use warsaw as a base theme
\usetheme{Warsaw}

% Define color which are loved by the Cr@ns ;)
\definecolor{crans-blue}{RGB}{34,68,120}
\definecolor{crans-light-blue}{RGB}{55,171,200}
\definecolor{crans-orange}{RGB}{255,102,0}

% Set text color in blocks
\setbeamercolor{normal text}{fg=black, bg=white}
% Set itemize and normal block's title color
\setbeamercolor{structure}{fg=crans-light-blue}

% Define new global colors for the theme
\setbeamercolor{palette primary}
{use={structure,normal text},fg=crans-orange,bg=crans-blue}

\setbeamercolor{palette secondary}
{use={structure,normal text},fg=crans-orange,bg=crans-blue!90}

\setbeamercolor{palette tertiary}
{use={structure,normal text},fg=crans-orange,bg=crans-blue!80}

\setbeamercolor{palette quaternary}
{use={structure,normal text},fg=crans-orange,bg=crans-blue!100}

% Add an info line to display some infos including slide number
\useoutertheme{crans}

% Navigation and presentation options
\setbeamercovered{invisible}
\setbeamertemplate{navigation symbols}{}

% Add a background to the slides
\usebackgroundtemplate{\includegraphics[width=\paperwidth,height=\paperheight]{background}}

% Add a logo on the slides
\logo{\includegraphics[width=2cm]{logoCrans}}

% Change the behaviour of itemizes
\setbeamertemplate{itemize item}[triangle]
\setbeamertemplate{itemize subitem}[circle]
\setbeamertemplate{itemize subsubitem}[square]
