class Celsius:
    def __init__(self, temperature = 0):
        self._temperature = temperature

    @property
    def temperature(self):
        print("Getting value")
        return self._temperature

    @temperature.setter
    def temperature(self, value):
        if value < -273:
            raise ValueError("Temperature below -273 is not possible")
        print("Setting value")
        self._temperature = value

>>> c = Celsius()
>>> c.temperature
Getting value
0
>>> c.temperature = 10
Setting value
