import logging
import math

logging.basicConfig(filename='calls.log', level = logging.DEBUG)

def logger(level=logging.DEBUG):
    def decorated(func):
        def wrapper(*args, **kwargs):
            logging.log(level, "Called function %s on %s"
                        % (func.__name__, args[1:]))
            return func(*args, **kwargs)
        return wrapper
    return decorated

class Vecteur:
    [...]

    @logger()
    def __calculer_norme(self):
        return math.sqrt(self.x**2 + self.y**2)

    @logger()
    def _update_norme(self):
        self.norme = self.__calculer_norme()

    @logger(logging.CRITICAL)
    def setcoords(self, newx, newy):
        self.x, self.y = newx, newy
        self._update_norme()
