import geometry
import math

class Vecteur:
    def __init__(self, x, y):
        self.x, self.y = x, y
        self._update_norme()

    def __calculer_norme(self):
        return math.sqrt(self.x**2 + self.y**2)

    def _update_norme(self):
        self.norme = self.__calculer_norme()

    def setcoords(self, newx, newy):
        self.x, self.y = newx, newy
        self._update_norme()

    def __repr__(self):
        return "(%d, %d)" % (self.x, self.y)

    def __str__(self):
        return "Vecteur de coordonnées (%d, %d)" % (self.x, self.y)

    def __add__(self, other):
        return Vecteur(self.x + other.x, self.y + other.y)


