>>> import math
>>> class Vecteur:
        def __init__(self, x, y):
            self.x, self.y = x, y
            self._update_norme()

        def __calculer_norme(self):
            return math.sqrt(self.x**2 + self.y**2)

        def _update_norme(self):
            self.norme = self.__calculer_norme()

        def setcoords(self, newx, newy):
            self.x, self.y = newx, newy
            self._update_norme()

>>> v = Vecteur(3, 4)
>>> v.norme
5.0
>>> v.x = 10
>>> v.norme
5.0
>>> v.setcoords(6, 8)
>>> v.norme
10.0
