---
title: Introduction à RedHat Ansible
subtitle: Automatisation et déploiement de services
author:
- erdnaxe, vulcain et otthorn
institute: CR@NS
date: Mardi 19 février 2019
header-includes:
- |
  ```{=latex}
  \usetheme{Madrid}
  \definecolor{a}{HTML}{df0e24}
  \setbeamercolor{structure}{fg=a!90!black}
  \newfontfamily\DejaSans{DejaVu Sans}
  ```
---

# Qu'est-ce qu'est Ansible et pourquoi on en parle autant ?

## Qu'est-ce qu'est Ansible ? Pourquoi on en parle autant ?

::: notes
Ansible sait aussi récupérer des "faits" sur les serveurs et écrire de la doc.
Boite à outil très puissante.
On ne parle pas dans ce séminaire de comment se SSH sur les serveurs,
de ce qu'est un bastion... car il faut d'abord des CT pour en discuter à Aurore
et faire des choix.
:::

### Introduction

Ansible est un logiciel de déploiement/configuration à distance,
écrit en python.
Il utilise **seulement SSH** et ne nécessite **pas de serveur**.

Peut effectuer un déploiement vers ou à partir de la destination.

### Par rapport à BCFG2

::: notes
BCFG2 n'est pas dans Debian alors qu'Ansible l'est.
Ansible peut se SSH vers les machines pour les déployer,
ou dans l'autre sens (mais moins commun car perte de l'intérêt).
:::

Communauté beaucoup plus grande, structure plus claire, syntaxe beaucoup plus
légère.

# Vocabulaire de base pour comprendre l'outil

## Vocabulaire de base pour comprendre l'outil (1)

### Inventaire

Un fichier décrivant les machines et les groupes de machines.

*Exemple de groupe* : conteneur hébergé chez OVH.

### Variables de groupe ou d'hôte

Fichiers définissant des variables pour une ou un groupe de machine.

### Playbooks

Une politique de déploiement, décrit les rôles des machines.

*Exemple* :
Déployer les serveurs, les replicats et les clients LDAP.

### Rôles

Un rôle qu'une machine doit repecter.

*Exemple* : Avoir Debian-Backports d'activé.

## Vocabulaire de base pour comprendre l'outil (2)

### Tâches

Une action d'un rôle. Utilise un module.

*Exemple* : Installer le paquet `supertuxkart` avec le module APT.

### Modules

*Exemples* : `apt`, `copy`, `template`...

Il y en a beaucoup dont certains en « *interface stable* » et certains
expérimentaux. Les modules sont tous documentés sur la documentation officielle.

Souvent quand on commence à faire quelque chose de complexe, en réalité on
peut l'écrire beaucoup plus simplement avec un simple module.

On peut développer son module en Python, mais il en a déjà beaucoup fournis.

## Structure finale de base (1)

```
hosts  # inventory file
group_vars/
   all/                 # For all hosts
     toto.yml           # > Variables
     vault.yml          # > Variables in a Ansible Vault
   ovh/                 # For hosts in `ovh` group
     local_ldap.yml
host_vars/              # Variables specific to one host
   hostname1.yml        # Please do rather groups

codimd.yml              # CodiMD playbook
roles/
    codimd/               # A first role
    debian-backports/     # Another role
```

## Structure finale d'un rôle (2)

```
codimd/
    tasks/
        main.yml                # First read file
        0_apt_dependencies.yml  # Included in main.yml
        1_user_group.yml        # Also included in main.yml
    templates/
        config.json.j2          # A Jinja2 template
        sequelizerc.j2

debian-backports/               # Another role
    tasks/
        main.yml                # All tasks
    templates/
        backports.list.j2       # A Jinja2 template
```

## À quoi ressemble une tâche ?

```
- name: Configure Debian Backports
  when: ansible_distribution == 'Debian'
  template:
    src: 'backports.list.j2'
    dest: '/etc/apt/sources.list.d/backports.list'
    mode: 0644
```

# Votre premier déployement !

## Votre premier déployement !

### Travaux pratiques

Il y a 3 groupes de niveau différent.

<https://codimd.auro.re/SeminaireAnsible>

