---
title: Introduction à PGP
subtitle: Chiffrer, déchiffrer et signer
author: Alexandre IOOSS, *erdnaxe*
institute: CR@NS
date: Mardi 13 novembre 2018
header-includes:
- |
  ```{=latex}
  \usetheme{Madrid}
  \definecolor{a}{HTML}{df0e24}
  \setbeamercolor{structure}{fg=a!90!black}
  \newfontfamily\DejaSans{DejaVu Sans}
  ```
---

::: notes
PGP : Pretty Good Privacy
:::

# Primitives cryptographiques



## Hachage

### But du hachage

Créer un *hash* qui identifie *rapidement* une donnée initiale.

### En pratique

Fonction de l'ensemble des données (infini) dans
l'ensemble des hash (fini), difficilement inversible.

. . .

### Exemples d'algorithmes

MD5, SHA1, SHA256...

. . .

### Utilisations

Mot de passe, salage, sûreté d'un téléchargement.

::: notes
salage : renforce la sécurité des informations qui sont destinées à être hachées
    (par exemple des mots de passe) en y ajoutant une donnée supplémentaire afin
    d'empêcher que deux informations identiques conduisent à la même empreinte
    (la résultante d’une fonction de hachage).
Histoire des faux en écriture avec les PDF
:::

## Hachage : À vous de jouer \DejaSans 😉

Utilisez md5sum, sha1sum et sha512sum pour hasher "J'aime le crans".

. . .

```bash
echo "J'aime le crans" > mon_fichier
md5sum mon_fichier
sha1sum mon_fichier
sha512sum mon_fichier
```

Allez sur [http://releases.ubuntu.com/18.04.1/](http://releases.ubuntu.com/18.04.1/).







## Chiffrement symétrique

### But du chiffrement symétrique

Communiquer de manière sûre avec un interlocuteur connu.

Il faut que le *secret* ne soit connu que de ces deux *pairs*.

Un *plaintext* s'échange en étant chiffrer en *cyphertext* puis déchiffrer.

::: notes
secret : clé de chriffrement
pairs : personne
plaintext : texte clair
cyphertext : forme illisible par qqu sans la clé
:::

. . .

### Exemples d'algorithmes

AES, DES, 3DES, Blowfish, XOR...

::: notes
AES : Advanced Encryption Standard (2001)
    Colum-major array of butes (matrice 4x4) > 128, 192, ou 256 bits
    Plusieurs fois le même algo appliqué
    Voir https://en.wikipedia.org/wiki/Advanced_Encryption_Standard
DES : Data Encryption Standard (1977)
    Précurseur d'AES > clé 8 bits
    Voir https://en.wikipedia.org/wiki/Data_Encryption_Standard
3DES : Triple DES (1998)
Blowfish : (1993)

SSH utilise symétrique après premier échange (rapide)
:::

. . .

Cas réel : Minecraft utilise AES/CFB8 pour jouer sur des serveurs *online*.







## Chiffrement asymétrique

### Fonctionnement

**Clé publique** : Tout le monde la possède. Sert à chiffrer des messages
qui ne sont pas déchiffrables sans clé privée.

**Clé privée** : gardée *jalousement*, elle permet de déchiffrer les
messages.

. . .

### Exemples d'algorithmes

RSA, ElGamal...

::: notes
RSA : Rivest–Shamir–Adleman.
ElGamel : (1985) Utilisé dans GPG.
:::

. . .

### Utilisations

En pratique, on préfère générer une clé symétrique, la chiffrer et
l'envoyer, puis continuer avec la communication avec du chiffrement
symétrique.

Souvent plus rapide. Plus efficace si l'on chiffre pour plusieurs
destinataires à la fois.

SSH, SSL...


::: notes
Clé privé avec passphrase pour gagner du temps si fuite de donnée
:::



## Illustration

::: columns
:::: column
![Chiffrement symétrique](symetric.png)
::::
:::: column
![Chiffrement asymétrique](pk_encryption.png)
::::
:::





## Pour la culture : principe de RSA

-   On choisit deux (*grands*) entiers $p$ et $q$ premiers et distincts

-   On pose $n=p\cdot q$

-   On calcule $\varphi(n) = \pause (p-1)(q-1)$

. . .

-   Soit $e$ entier inférieur à, et premier avec, $\varphi(n)$

. . .

-   Calculer $d\equiv e^{-1} \mod \varphi(n)$

-   On remarque que pour tout $M$ entier,
    $M^{e\cdot d} \equiv \pause M \mod n$.

. . .

::: notes
Thm de Fermat

Dire : et maintenant on prend quoi en public/privé ?
:::

Clef publique : $(n,e)$ \quad\quad Clef privée : $d$.









## Signature

::: notes
Proche du chiffrement asymétrique mais pas rigoureusement pareil (cf tudor).
:::

### But de la signature

Opération inverse : prouver son identité.

**Clé privée** : gardée jalousement, elle permet d'émettre (signer) des
messages.

**Clé publique** : Tout le monde la possède. Sert à vérifier les
signatures, émises par la clé privée.

. . .

### Exemples d'algorithmes
DSA, RSA,
ElGamal, courbes elliptiques.

. . .

### Application

Signer des mails, signer des paquets logiciels.

En pratique : on préfère signer le hash du message.

::: notes
Signature de driver Windows,
Signature des paquets Archlinux...
:::

## Illustration

![](signature.jpg)

::: notes
On signe un digest (résultant d'une fonction de hash).
:::

## Introduction aux réseaux de confiance

Comment s'échanger les clés publiques initialement ?

-   Rencontrer la personne en vrai ;

::: notes
parfois être social ça aide
:::

. . .

-   Une clé c'est long : l'échanger grâce à une clé, au réseau local...

::: notes
Asymétrique puis Symétrique
:::

. . .

-   La télécharger sur Internet, mais demander à son interlocuteur, dans
    la vraie vie, de confirmer le hash (empreinte) ;

. . .

-   Sinon : demander à un (des) intermédiaire(s) de confiance d'attester
    de l'authenticité de la clé (signatures).












# GPG

## GPG ou PGP ?

### OpenPGP

Format et protocole de cryptographie.

. . .

### GnuPG (GPG)

Une des implémentations de OpenPGP, sous licence GNU GPL.

`apt install gnupg` (souvent pré-installé)

## Générer une clef

### Pour générer une clef PGP

Avec `gpg --gen-key`

-   Taille de clé : entre 2048 et 4096 ;
-   Plus la clef est longue, plus elle est dure à casser ;
-   ... mais également plus lourde ;
-   ... mais également plus longue à générer.

Recommandation pour le RSA par l'*ANSSI* :
4096 bits (pour > 2020).

::: notes
ANSSI : Agence Nationale de la Sécurité des Système d'Information
4096 bits car puissance de calcul augmente

Augmenter l'entropie lors de la génération en faisant nawak.
:::

. . .

### Remarques sur la génération de clef

-   **La date d'expiration** peut-être changée après génération ;
-   **Identité** : c'est le nom et le mail qui apparaîtra pour les autres ;
-   **Passphrase** : dernière protection en cas de vol de la clef privée.

::: notes
La date d'expiration : changer en cas de perte ou vol de la clef
Mail visible : indiquer votre adresse d'envoi habituelle
Passphrase : permet uniquement de gagner un peu de temps en cas de vol
:::

## Générer une clef

### Générer un certificat de révocation

Avec `gpg --gen-revoke`

Exemple : `gpg --output mon_certif_de_revocation.asc --gen-revoke 6E1C820B`

. . .

### Une clef PGP est composée de :

`gpg --list-keys 6E1C820B`

-   **Une clé cryptographique** publique de signature ;
-   **Des identités** : nom et mail ;
-   **Des sous-clefs** (chiffrement, signature, authentification,
    certificat) ;
-   **Des signatures** (`gpg --list-sigs 6E1C820B`) ;
-   Les clefs cryptographiques privées associées (si c'est la votre).

::: notes
Démo : gpg --list-keys A8B68FA13E865318
:::

## Échange de clefs

### Publier sa clef PGP

-   `gpg --armour --export 6E1C820B `

-   Sur sa page perso, par mail, etc

-   Ou alors... \pause utiliser un serveur de clé !

-   `gpg --send-key 6E1C820B`

::: notes
Démo : gpg --armour --export A8B68FA13E865318
:::

. . .

### Récupérer la clé PGP de quelqu'un

-   Sur sa page perso, par mail, etc

-   `gpg --import`

-   Ou alors... \pause utiliser un serveur de clé !

-   `gpg --recv-key 6E1C820B` (hkp://keys.gnupg.net)

. . .

-   `gpg --search-keys erdnaxe` (à vous d'essayez !)

. . .

\Huge Attention :\normalsize
Vous n'avez a priori aucune raison d'avoir confiance en cette clef !

## Signer

### Comment vérifier qu'une clef appartient bien à son propriétaire ?

-   Rencontrer la personne en vrai, et échanger physiquement la clef ;

. . .

-   La télécharger (Internet) et échanger physiquement le hash
    (empreinte) ;

. . .

Dans tous les cas, il faut rencontrer physiquement la personne. 

. . .

\Huge Attention :\normalsize
ne pas confondre ID et empreinte de clef !

::: notes
id : identifiant
empreinte : hash de la clé publique
>>>>>> gpg --fingerprint A8B68FA13E865318
:::

. . .

### Signature de signatures, pourquoi ?

-   Attester aux autres de l'identité d'une clef ;

. . .

-   Mais au fond, qu'est-ce qu'une identité ? \pause
    Vérification souvent d'une pièce d'identité officielle.

::: notes
la personne ne veut pas perdre en crédibilité et signer n'importe quel clé de
signature
:::

. . .

-   La manière dont vous signez une personne peut influencer la
    confiance qu'elle accordera à votre clé !

## Signer

### *Une* procédure de signature

On passe en mode édition avec `gpg --edit-key [user]`\

-   `fpr` (se faire dicter la clef)
-   Vérifier une pièce d'identité
-   `sign`
-   `trust`
-   `save`

. . .

Renvoyer la clef signée : `gpg --send-key 6E1C820B` (ou
`gpg --export 6E1C820B`).

. . .

NB : d'autres méthodes de signature sont
envisageables quand de nombreuses personnes veulent s'entre-signer.

## Trousseau de clefs

-   Situé dans `~/.gnupg/` ;
-   Contient les clefs privées ;
-   Contient les clés téléchargées ;

. . .

-   Et les niveau de confiance !

Pensez à mettre à jour :

-   Les clefs de votre trousseau : `gpg --refresh-keys` ;
-   Sa base de confiance : `gpg --update-trustdb`

::: notes
Démo : gpg --refresh-keys
:::

# Applications

## Chiffrer & signer

-   `gpg --armour -e -r erdnaxe [fichier]` nécessite une confiance suffisante
    en la clé destination ;

::: notes
chiffre
:::

. . .

-   `gpg -d [fichier]` nécessite de posséder la clef privée associée ;

::: notes
déchiffre
:::

. . .

-   Signer : `gpg --armour -s [fichier]` ;

-   Vérifier une signature : `gpg --verify [fichier]` ;

. . .

-   Version claire : `gpg --clearsign [fichier]`.

## Envoyer des mails

-   Thunderbird (Enigmail) ;
-   GMail web (FlowCrypt) ;
-   etc...

## CransPasswords (instant pub)

-   Projet Cranseux de partage de mot de passe

-   Plusieurs *roles* : nounous, apprentis, ca

-   Plusieurs fichiers

-   Il faut être signé par la personne qui chiffre les mots de passe

Tout est sur le Gitlab du Crans !

# Conclusion {-}

## Ce dont on n'a pas parlé (liste non exhaustive)

-   Comment garder sa clé maîtresse à l'abris ;

-   Créer des sous-clés de chiffrement ;

-   Mettre à jour les dates d'expiration ;

-   Batch signer plusieurs personnes et valider leur mail ;

-   Utiliser une smartcard ;

-   Comment gérer/personaliser son réseau de confiance.

## Quelques liens

-   Voir le PDF sur le Wiki !
-   <http://doc.ubuntu-fr.org/gnupg>
-   <http://fr.wikibooks.org/wiki/GPG>
-   <http://www.gnupg.org/gph/fr/manual.html>
-   <http://www.legifrance.gouv.fr/>
-   <http://fr.wikipedia.org/wiki/Cryptographie>
-   <http://security.stackexchange.com/questions/5096/>
-   <http://www.linuxquestions.org/questions/linux-security-4/>
-   <http://wiki.debian.org/Subkeys>
-   <https://www.dcode.fr/>

## À vous

-   `gpg --search-key erdnaxe`

-   `gpg --recv-key A8B68FA13E865318`

-   `gpg --keyserver keyserver.ubuntu.com --recv 25B9AD73BBFBD54E`

-   `gpg --edit-key`

-   `gpg --armour --export A8B68FA13E865318`
