---
title: Introduction à Red Hat Ansible
subtitle: Automatisation et déploiement de services[^1]
author:
- Alexandre « erdnaxe » Iooss
institute: CR@NS
date: Lundi 2 décembre 2019
header-includes:
- |
  ```{=latex}
  \usetheme{Madrid}
  \definecolor{a}{HTML}{df0e24}
  \setbeamercolor{structure}{fg=a!90!black}
  \newfontfamily\DejaSans{DejaVu Sans}
  ```
---

[^1]: Ou « *Comment faire du `cssh` de manière plus propre ?* ».

# Présentation de l'outil et concepts de base

## Que fait-on pour administrer un serveur à distance ?

### Parcours traditionnel

  * On se connecte de façon sécurisée à une machine par `ssh` ;
  * On collecte **des faits** sur notre serveurs (*facts*) ;
  * On se rappel que ce serveur a **des rôles** à jouer (*roles*) ;
  * On effectue **des tâches** d’administration selon les rôles (*tasks*) ;
  * On se déconnecte et on se remémore tout nos exploits ou échecs.

Simple à réaliser pour un serveur… Mais long et barbant
pour $N$ serveurs.\pause

### Parcours Ansible d'une recette (*playbook*)

  * Ansible se connecte de façon sécurisée à $N$ machines par `ssh` ;
  * Ansible collecte **des faits** sur notre serveurs (*facts*) ;
  * Ansible récupère **les rôles** que chaque serveur doit respecter (*roles*) ;
  * Ansible effectue **des tâches** d’administration selon les rôles (*tasks*) ;
  * Ansible renvoi un récapitulatif des modifications.

Ça fait presque le café ! Permet d'harmoniser un parc sans erreur humaine.

## Points particuliers d'Ansible

Il ne nécessite pas de bastion.\pause

On peut lui faire utiliser son utilisateur avec `sudo`.
\pause

La communauté est très grande et beaucoup de modules et plugins sont
disponibles ce qui lui fait sa grande force.

## Structure

### Inventaire

Un fichier décrivant les machines et les groupes de machines.

*Bonne pratique* : groupe « lieu_type ».

### Playbooks

Une politique de déploiement, associe des rôles à des machines.

*Bonne pratique* : on peut définir des variables réutilisables
dans les rôles.

### Rôles

Un rôle qu'une machine doit respecter. Contient des tâches ordonnées.

*Exemple* : Avoir le contrôleur Unifi d'installé.

### Tâches

Une action d'un rôle. Utilise un module.

*Exemple* : Installer le paquet `teeworld` avec le module APT.

## Structure (2)

### Modules

*Exemples* : `apt`, `copy`, `template`...

Les modules sont tous documentés sur **la documentation officielle**.

Souvent quand on commence à faire quelque chose de complexe, en réalité on
peut l'écrire beaucoup plus simplement avec un simple module.

Si un module manque, on peut en développer un en Python.

## Structure sur le système de fichier

```
hosts                 # An inventory file
monitoring.yml        # A playbook assigning roles
roles/
    codimd/           # A first role
        tasks/
            main.yml  # Contains tasks of this role
        templates/    # Contains files for "template" module

    unifi-controller/ # Another role
        tasks/
            main.yml  # Contains tasks of this role
        files/        # Contains files for "file" module
```

# Votre premier déploiement !

## Votre premier déploiement

Si vous n'avez pas Ansible sur votre machine, vous pouvez
`ssh -p 2222 invite@hackme.servens.club`.
Le mot de passe est `seminaireansible`.

Votre mission, si vous l'acceptez, est de la provisionner
la machine accessible sur `10.0.0.12`
afin d'écrire votre nom à la fin du fichier `/tmp/you_have_been_pwnd_by`.

Pour cela :

  * Créez une clé SSH[^2] si vous en avez déjà pas une. La déployer sur ma
    machine[^3] vous que vous puissiez vous connecter avec.
  * Installez Ansible sur votre machine.
  * Créez un playbook avec un rôle et une tâche (module `lineinfile`).
  * Déployez et profitez !

[^2]: `ssh-keygen -t rsa -b 4096` puis `ssh-add ~/.ssh/id_rsa`
[^3]: `ssh-copy-id invite@hackme.servens.club -p 2222`

