---
title: An introduction to WebRTC
subtitle: Real-Time Communication over the Web
author: Alexandre Iooss
#date: 21th May 2021
date: 20th May 2021
institute: Workshop Crans
#institute: Lunch talk
header-includes:
- |
  ```{=latex}
  \usetheme{Madrid}
  %\definecolor{a}{HTML}{b51e1e}
  \definecolor{a}{HTML}{1F95AD}
  \setbeamercolor{structure}{fg=a!90!black}
  \newfontfamily\DejaSans{DejaVu Sans}
  \usebackgroundtemplate{\includegraphics[width=\paperwidth,height=\paperheight]{assets/background.pdf}}
  ```
---

<!--
WebRTC revolutionised videoconferencing on the Web. During this short
introduction on WebRTC, you will discover the different technologies that enable
modern applications such as Zoom, Jitsi, BigBlueButton and Skype to manage
real-time audio and video communications over an unstable and chaotic Internet. 

You are not hearing your supervisor on Skype anymore? You sound like being in a
submarine on Discord? The goal of this presentation is to explain what is
happening behind the scene and to give advice and tools to understand these
issues.

--

Venez découvrir le standard qui a révolutionné la visioconférence sur le Web. Lors de cette courte introduction sur ce qu'est le WebRTC, vous découvrirez les différentes technologies qui permettent aux applications de visioconférence de réaliser de la communication en temps réel sur Internet.

Vous n'entendez plus votre maître de stage sur Zoom ? Vous sonnez comme étant dans un sous-marin sur Discord ? Le but de ce workshop est de vous donnez les outils pour que vous sachiez qui est le fautif dans ces situations et améliorer la qualité de vos appels.

Ambiance conviviale. Présentation de 10-20minutes puis session de questions et de partage de retours d'expérience entre les différentes plateformes existantes.
-->

![Warning, acronyms incoming](assets/meme_acronyms.png){width=70%}

# WebRTC usage in the real world

## Practical use case (1): videoconferencing

Many people can interact with each other in a "room".
You are right now using WebRTC!

## Practical use case (2): streaming workshops at CRANS

Started learning about WebRTC in September 2020 to develop a self-hosted
streaming solution to organise workshops at CRANS student network organisation.

Different problematic versions before achieving something stable:

1.   May-September 2020: HLS streaming via HTTP with NGINX web server, huge latency. <!-- SLOWWWW, codec problems -->
2.   September-October 2020: SRT to WebRTC using custom server implemented in Golang, built with FFMpeg and Pion v3-beta, unstable. <!-- stability problem, I was learning Golang, FFMpeg and WebRTC -->
3.   October-March 2020: back to HLS with OvenMediaEngine and FFMpeg as RTMP server, complex to maintain, last resort solution.
4.   March 2020: WebRTC using Galène.

## Communicating over Internet: TCP and UDP

<!-- Internet is unstable -->

**TCP** (Transmission Control Protocol): 3-way handshake, reliable, error-detection.

**UDP** (User Datagram Protocol): no handshaking, only checksum.
Will loose packets.

<!--
UDP is covid-friendly
-->

For audio/video streaming, UDP can make more sense.

Web browsers were not able to do UDP until WebRTC.

<!--
HTTP/3, QUIC is going UDP

error correction in codec, NACK, PLI...
-->

## TCP joke

TCP adds overhead to the communication.

```
- Hello, would you like to hear a TCP joke?
- Yes, I'd like to hear a TCP joke. 
- OK, I'll tell you a TCP joke. 
- OK, I'll hear a TCP joke. 
- Are you ready to hear a TCP joke? 
- Yes, I am ready to hear a TCP joke. 
- OK, I'm about to send the TCP joke.
  It will last 10 seconds, it has two characters,
  it does not have a setting, it ends with a punchline. 
- OK, I'm ready to hear the TCP joke that will last
  10 seconds, has two characters, does not have a setting...
- I'm sorry, your connection has timed out...
  ...Hello, would you like to hear a TCP joke? 
```

## What is WebRTC?

<!-- Goal: Enable people to understand what is happening next time their WebRTC software is not working

Which is the best software (depend) ? -->

**Standards implemented in browsers** to allow **real-time peer-to-peer** communication.
Should[^zoom] not require a plugin or a heavy app!

<!-- First draft by Ericsson Labs in January 2011

W3C WebRTC 1.0,  W3C Recommendation 26 January 2021 
-->

<!-- Look like IPTV but without SAP and outdated codecs. -->

![](assets/stack.pdf)

Used by many major videoconferencing software.
Popular implementations: LibWebRTC (in C++, Chromium and Firefox project), GStreamer (in C),
Pion/Ion (in Golang).

Developers only need to design and implement sessions signalling.

<!--
DTLS: datagram TLS
SRTP: secure RTP
RTP: realtime protocol
-->

[^zoom]: videoconferencing apps are embedding modified web browsers.

## WebRTC topologies

![](assets/topology.pdf)

-   **Mesh**: no server but need to upload stream to many peer.
-   **Multipoint Conferencing Unit**: optimal for peers, but require decoding then encoding on the server.
-   **Selective Forwarding Unit**: the server is just a audio/video router. This is what is mostly being used.

The stream sent to the SFU can be a Simulcast stream: multiple qualities in one stream.
The SFU can then decide what quality to forward in regard to network congestion.

<!--
Jitsi says that it mesh when only 2 peer in one room, in practise did not work on my side.
-->

## Reaching your peer(s)

Problem: find a public IP address (identifies your device on Internet) to which to send the RTP stream.

*Magic* with **ICE** (Interactive Connectivity Establishment): peers are
sending every IP they think enable the other to reach them, **included local IP**.

How to know we are behind a NAT[^NAT] and find our public IP address? **STUN** (Session Traversal Utilities for NAT) servers!

If it fails (chaotic NAT, restricted networks) then it uses a proxy server: **TURN** (Traversal Using Relays around NAT).

<!-- This would not be a problem with IPv6... -->

[^NAT]: Mapping to share one public IP address with multiple local IP addresses.

## A little bit of audio and video codecs history

### Video codecs for the Web

Royalty-free video format: VP7 (On2) $\rightarrow$ **VP8** (2008, Google, open) $\rightarrow$ **VP9** (2013, Google, open) $\rightarrow$ **AV1** (2018, Alliance for Open Media, open)

**H264** is not royalty-free.

### Audio codecs for the Web

**SILK** (2009, Skype) $\rightarrow$ **Opus** (2012, RFC6716)

### Real-Time Protocol

**RTP** (1996) defines a way to send audio or video streams
over UDP. RTSP, SIP, SAP or XMPP is used to initiate the session.

Some use-cases: IPTV, VoIP, VoLTE and WebRTC.

<!-- VP8 spec creative common attribution
VP9: parts of the format are covered by patents held by Google.

Firefox uses OpenH264 from Cisco
https://support.mozilla.org/en-US/kb/open-h264-plugin-firefox

In WebRTC there is no equivalent to RTSP/SIP/SAP, it's the dev job to forward the SDP

SIP: session inityiation protocol
SAP: session announcement protocol (IPTV)
-->

## What differentiates WebRTC conferencing software?

| Software      | Video codecs | Audio codecs | TURN | IPv6  |
|---------------|--------------|--------------|------|-------|
| BigBlueButton | VP8          | Opus stereo  | $\checkmark$ | video        |
| Discord       | H264         | Opus         | $\times$     | $\times$     |
| Galène        | VP8/VP9/H264 | Opus stereo  | $\checkmark$ | $\checkmark$ |
| Jitsi         | VP8/VP9/H264 | Opus + ISAC  | $\times$     | $\checkmark$ |
| Meet          | VP8          | Opus + G.722  | $\times$     | $\checkmark$ |
| Peercalls     | VP8/H264     | Opus stereo  | $\checkmark$ | $\times$     |
| Skype         | H264         | \textcolor{red}{G.722 + PCM} | $\checkmark$ | $\times$     |
| Zoom          | Custom H264  | Custom SILK  | \textit{\textcolor{red}{WebSocket}}  | $\times$     |

Table: Analyse of WebRTC sessions using Firefox 88 on 2021-05-15

<!--
BigBlueButton and Zoom: two WebRTC sessions.

Discord: 11 audio and 11 video streams with only 2 peers

Google Meet does not do video PLI. They might encode video i-frames more often.

Does not tell the whole story, Discord, Zoom and Galène is >> others on audio video for example
-->

## What differentiates WebRTC conferencing software?

![Basically Zoom](assets/zoom.png){width=60%}

Zoom is using RTP over WebSocket (TCP) as a fallback.
<!-- Custom WebAssembly code

SILK was developed by Skype and Zoom is running it in WebAssembly.
-- https://webrtchacks.com/red-improving-audio-quality-with-redundancy/
-->

# Thoubleshooting WebRTC

## What often goes wrong?

### No video and/or no audio

Session negotiation failed.

<!--
Network, TURN
The intersection of both descriptions might be null.
-->

### Choppy video

Your browser or peer might not handle retransmission requests correctly,
or network is congested.

<!-- Pion <-> GStreamer
Pion does not support RTX on separate SSRC
-->

### Crackling audio

You are loosing a lot of packets and
the audio Forward Error Correction (FEC) is not keeping up.

### You are sounding like in a submarine to your peers

You are overflowing your echo suppressor.

## Best practises to reduce problems

-   Use Ethernet for robustness rather than WiFi/LTE. <!-- air time with many clients -->
-   Use headphones to reduce the job of the echo suppressor.
-   [*Safari is the new Internet Explorer.*](https://www.safari-is-the-new-ie.com) Don't use it for video calling. <!-- Use Brave, Firefox or Chrome-based browsers -->
-   If you can, enable IPv6. This prevents chaotic NAT problems. <!-- also remove sometime the necessity for TURN, removing an overhead -->

## What to do during my boring lunch talk?

You can be curious and explore `about:webrtc` (Firefox) or `chrome://webrtc-internals` (Chromium-based browsers).
It's not dangerous and can help figure out what is happening.

![](assets/chromewebrtc.png){width=48%}
![](assets/aboutwebrtc.png){width=48%}


<!-- Failed negotiations on Firefox side with my local IP => it leeks my local IP :'/ -->

# The future of WebRTC

## Is WebRTC going to replace HTTP video streaming?

Major platforms such as Twitch, Youtube, PeerTube and Netflix are based on **HLS** (HTTP Live Streaming, Apple) and **MPEG-DASH** (Dynamic Adaptive Streaming over HTTP).

WebRTC is not as easy to scale up as HTTP caches, but it can achieve sub-second
latency. WebRTC in streaming software is still experimental.

![Example of PeerTube instance](assets/peertube.png){width=60%}

<!--
problem of having multiple qualities: SimulCast

SFU: selective forwarding unit

Streaming software does not support (yet) WebRTC.

Google seems to want to make WebRTC part of HTTP/3
-->

## What is currently missing/coming?

-   AV1 video codecs with built-in SVC.
-   WebRTC in OBS Studio (Q4 2021).
-   Privacy concerns with the negotiation leaking local IP addresses.
-   ULP-FEC support in browsers: increase robustness to packet loss compared to in-band Opus FEC.
-   Voice activity detection on Firefox.
-   HTTP/3: QUIC (HTTP over UDP) as replacement for SRTP and WebSockets.

\pause

Thank you for listening :)


