#!/bin/bash

TMUX_SESSION=TP1



#                      +~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
#                      | Mise en place du TP virtuel |
#                      +~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
function add_window_netns () {
	# NETNS: $2
	# WINDOW_ID: $1
	tmux split-pane -h -t $TMUX_SESSION:$1.0
	tmux split-pane -v -t $TMUX_SESSION:$1.0
	tmux split-pane -v -t $TMUX_SESSION:$1.2
	tmux split-pane -v -t $TMUX_SESSION:$1.3

	if [[ $2 ]]; then
		tmux send-keys -t $TMUX_SESSION:$1.0 "sudo ip netns exec $2 bash" C-m
		tmux send-keys -t $TMUX_SESSION:$1.1 "sudo ip netns exec $2 bash" C-m
		tmux send-keys -t $TMUX_SESSION:$1.2 "sudo ip netns exec $2 bash" C-m
		tmux send-keys -t $TMUX_SESSION:$1.3 "sudo ip netns exec $2 bash" C-m
		tmux send-keys -t $TMUX_SESSION:$1.4 "sudo ip netns exec $2 bash" C-m
	fi
	tmux send-keys -t $TMUX_SESSION:$1.0 "export COLORFGBG=\"7;0\"" C-m
	tmux send-keys -t $TMUX_SESSION:$1.1 "sudo -i" C-m
	tmux send-keys -t $TMUX_SESSION:$1.1 "export COLORFGBG=\"7;0\"" C-m
	tmux send-keys -t $TMUX_SESSION:$1.2 "export COLORFGBG=\"7;0\"" C-m
	tmux send-keys -t $TMUX_SESSION:$1.3 "export COLORFGBG=\"7;0\"" C-m
	tmux send-keys -t $TMUX_SESSION:$1.4 "export COLORFGBG=\"7;0\"" C-m

	tmux send-keys -t $TMUX_SESSION:$1.0 "watch sudo nft list ruleset" C-m
	tmux send-keys -t $TMUX_SESSION:$1.2 "watch -c ip -c a" C-m
	tmux send-keys -t $TMUX_SESSION:$1.3 "watch -c ip -c r" C-m
	tmux send-keys -t $TMUX_SESSION:$1.4 "watch -c ip -c n" C-m
}
function reset_nftables () {
	tmux send-keys -t $TMUX_SESSION:$1.1 "nft flush ruleset" C-m
	tmux send-keys -t $TMUX_SESSION:$1.1 "nft add table inet filter" C-m
	tmux send-keys -t $TMUX_SESSION:$1.1 "nft add chain inet filter input '{type filter hook input priority filter;policy drop;}'" C-m
	tmux send-keys -t $TMUX_SESSION:$1.1 "nft add rule inet filter input 'iifname \"lo\" accept'" C-m
	tmux send-keys -t $TMUX_SESSION:$1.1 "nft add rule inet filter input 'ct state {established, related} accept'" C-m
}

# setting up windows
tmux rename-window -t TP1:0 "routeur"
add_window_netns 0

sudo ip netns add TP1_client
tmux new-window -t TP1; tmux rename-window -t TP1:1 "client"
add_window_netns 1 TP1_client

# Ajout du câble Ethernet virtuel entre le routeur et le client
sudo ip link add cable_routeur type veth peer name cable_client
sudo ip link set netns TP1_client cable_client
tmux send-keys -t $TMUX_SESSION:1.1 "sudo ip link set up lo" C-m

tmux send-keys -t $TMUX_SESSION:0.1 "clear" C-m
tmux send-keys -t $TMUX_SESSION:1.1 "clear" C-m

# Réinitialisation de nftables pour le routeur et le client (règles basiques)
reset_nftables 0
reset_nftables 1

