#!/bin/bash

TMUX_SESSION=TP1
out_ifname=enp5s0
ROUTER_ADDR=192.168.10.1
CLIENT_ADDR=192.168.10.2
NETMASK=30


#                      +~~~~~~~~~~~~~~~~~~+
#                      | Correction du TP |
#                      +~~~~~~~~~~~~~~~~~~+

# +~~~~Routeur : ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
# |    ---------                                                           |
# |                                                                        |
# | sudo sysctl net.ipv4.ip_forward=1                                      |
# | sudo nft add table ip nat                                              |
# | sudo nft add chain ip nat postrouting '{type nat hook postrouting \    |
# |      priority srcnat}';                                                |
# | sudo nft add rule ip nat postrouting 'oifname $out_ifname masquerade'  |
# |                                                                        |
# | sudo ip link set up dev cable_routeur                                  |
# | sudo ip address add $ROUTER_ADDR dev cable_routeur                     |
# |                                                                        |
# +~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+

tmux send-keys -t $TMUX_SESSION:0.1 "sudo sysctl net.ipv4.ip_forward=1" C-m
tmux send-keys -t $TMUX_SESSION:0.1 "sudo nft add table ip nat" C-m
tmux send-keys -t $TMUX_SESSION:0.1 "sudo nft add chain ip nat postrouting '{ type nat hook postrouting priority srcnat; }'" C-m
tmux send-keys -t $TMUX_SESSION:0.1 "sudo nft add rule ip nat postrouting 'oifname $out_ifname masquerade'" C-m
tmux send-keys -t $TMUX_SESSION:0.1 "sudo ip link set up dev cable_routeur" C-m
tmux send-keys -t $TMUX_SESSION:0.1 "sudo ip address add $ROUTER_ADDR/$NETMASK dev cable_routeur" C-m


# +~~~~Client : ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
# |    --------                                                            |
# |                                                                        |
# | sudo ip link set up dev cable_client                                   |
# | sudo ip address add $CLIENT_ADDR dev cable_client                      |
# |                                                                        |
# | sudo ip route add default via $ROUTER_ADDR                             |
# | mtr crans.org                                                          |
# |                                                                        |
# +~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+

tmux send-keys -t $TMUX_SESSION:1.1 "sudo ip link set up dev cable_client" C-m
tmux send-keys -t $TMUX_SESSION:1.1 "sudo ip address add $CLIENT_ADDR/$NETMASK dev cable_client" C-m
tmux send-keys -t $TMUX_SESSION:1.1 "sudo ip route add default via $ROUTER_ADDR" C-m
tmux send-keys -t $TMUX_SESSION:1.1 "mtr crans.org" C-m
