#!/bin/bash

TMUX_SESSION=TP2

#            +~~~~~~~~~~~~~~~~~~~~~~~~+
#            | Ajout des addresses ip |
#            +~~~~~~~~~~~~~~~~~~~~~~~~+
sudo ip address add 192.168.1.1/24 dev eth0
sudo ip netns exec c1 ip address add 192.168.1.2/24 dev eth0
sudo ip netns exec r2 ip address add 192.168.1.3/24 dev eth0
sudo ip netns exec r2 ip address add 192.168.2.1/24 dev eth1
sudo ip netns exec c2 ip address add 192.168.2.2/24 dev eth0



#            +~~~~~~~~~~~~~~~~~~~~~~~~~+
#            | Allumage des interfaces |
#            +~~~~~~~~~~~~~~~~~~~~~~~~~+
sudo ip link set up dev eth0

sudo ip netns exec sw0ns ip link set up dev r1_sw
sudo ip netns exec sw0ns ip link set up dev c1_sw
sudo ip netns exec sw0ns ip link set up dev r2_sw
sudo ip netns exec sw1ns ip link set up dev r2_sw
sudo ip netns exec sw1ns ip link set up dev c2_sw

sudo ip netns exec c1 ip link set up dev eth0
sudo ip netns exec r2 ip link set up dev eth0
sudo ip netns exec r2 ip link set up dev eth1
sudo ip netns exec c2 ip link set up dev eth0

sudo ip netns exec sw0ns ip link set up dev sw
sudo ip netns exec sw1ns ip link set up dev sw



#            +~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
#            | Gestion des règles NFTables |
#            +~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
function basic_filter () {
	sudo ip netns exec $1 nft flush ruleset
	sudo ip netns exec $1 nft add table inet filter
	sudo ip netns exec $1 nft add chain inet filter input '{ type filter hook input priority filter; policy drop; }'
	sudo ip netns exec $1 nft add rule inet filter input 'iifname "lo" accept'
	sudo ip netns exec $1 nft add rule inet filter input 'ct state {established, related} accept'
	sudo ip netns exec $1 nft add rule inet filter input 'ip protocol icmp counter accept'
}
function set_masquerade () {
	sudo ip netns exec $1 nft add table ip nat
	sudo ip netns exec $1 nft add chain ip nat postrouting '{ type nat hook postrouting priority srcnat; }'
	sudo ip netns exec $1 nft add rule ip nat postrouting "oifname $2 masquerade"
}

basic_filter c1
basic_filter r2
basic_filter c2
set_masquerade r2 eth0

sudo sysctl net.ipv4.ip_forward=1
sudo ip netns exec r2 sysctl net.ipv4.ip_forward=1
sudo ip netns exec c1 ip route add default via 192.168.1.1
sudo ip netns exec r2 ip route add default via 192.168.1.1
sudo ip netns exec c2 ip route add default via 192.168.2.1

sudo ip route add 192.168.2.0/24 via 192.168.1.3



#                      +~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
#                      | Test de connectivité + ping c1 → c2 |
#                      +~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+
tmux send-keys -t $TMUX_SESSION:0.1 "mtr google.com" C-m
tmux send-keys -t $TMUX_SESSION:1.1 "mtr 192.168.2.2" C-m
tmux send-keys -t $TMUX_SESSION:2.1 "mtr google.com" C-m
tmux send-keys -t $TMUX_SESSION:3.1 "mtr google.com" C-m

