---
title: Mathématiques pour la modélisation et la simulation
subtitle: SAPHIRE - 101
---

# Distributions

## Introduction, limite des fonctions, approche physique

Le comportement de nombreux systèmes physiques est décrit par des équations
différentielles faisant intervenir des grandeurs qui sont des fonctions
continues ($v_c(t)$, $i_L(t)$...).

Ainsi si le système suit l'équation différentielle à partir de $t=t_0$ et si
on connaît la valeur des grandeurs continues à $t=t_0^{-}$, alors on peut en
déduire leur valeur en $t=t_0^{+}$.

Cependant on rencontre un certain nombre de systèmes avec des grandeurs
discontinues. C'est souvent dans des situations limites ou si on a
« mal choisi » les grandeurs.

**Ex 1** : $i(t)$ dans un circuit RC avec R qui tend vers 0.

**Ex 2** : $f(t)$ pour un rebond élastique d'une balle sur une paroi immobile.
$f(t)$ n'est pas une fonction classique sinon on aurait
$\int_{0^-}^{0^+} f = 0$.

**Ex 3** : Charges électriques en électrostatique.
Pour une charge ponctuelle $q$
en $M$, elle agit et crée un potentiel à l'origine $O$ (à la distance $r$) :
$U_M=\frac{1}{4\pi\epsilon_0}\frac{q_M}{r}$ (2).

Distribution de charges dans un volume $v$ de densité volumique de charge
$\rho$: 

* Charge totale $q=\iiint_V \rho_v\,\mathrm{d}v$ (3) ;
* Potentiel à l'origine
  $u=\frac{1}{4\pi\epsilon_0}\iiint\frac{\rho_v}{r}\,\mathrm{d}v$ (4).

Aucun appareil de mesure nous donne directement la valeur de la densité de
charge. On ne peut qu'en mesurer l'effet et accéder à la valeur indirectement.

Par exemple, $\int_{\mathbb{R}^3} \rho(M)\,\varphi(M)\,\mathrm{d}M$ avec :

* Pour $q$ : $\varphi(M) = 1$ ;
* Pour $u$ : $\varphi(M) = \frac{1}{4\pi\epsilon_0}\frac{1}{r}$ ;

$$ \rho: \varphi \mapsto \langle\rho,\varphi\rangle $$

En connaissant l'intégrale pour un ensemble de fonction $\varphi$, on peut
remonter à $\rho$.

Comment passer de (1) à (3), de (2) à (4) ?

$$ lim_{v\rightarrow0} \langle\rho_v, \varphi\rangle = q_M \varphi(M) $$
$$ = q_M \langle\delta_M, \varphi\rangle $$

avec $\delta_M$ une impulsion de Dirac.

**Ex 4** : capteur de température le long d'une barre.

Le capteur n'est pas ponctuel, donc on ne peut pas accéder à la température
$\theta(x_0)$ car on mesure $\theta_0$ pour le voisinage $V(x_0)$.

$$ \theta_0 = \frac{1}{2\Delta} \int_{x_0-\Delta}^{x_0+\Delta} \theta $$
$$ = \int_{-\infty}^{+\infty} \theta(x)\,\varphi(x)\,\mathrm{d}x $$
$$ = \langle\theta, \varphi_0\rangle $$

$\varphi_0$ est modélisé ici par une fonction valant $\frac{1}{2\Delta}$ entre
$x_0-\Delta$ et $x_0+\Delta$ et sinon nulle.

En réalité $\varphi_0$ dépend du capteur.

**La théorie des distributions permet de généraliser la notion de fonction,
d'étendre la notion de dérivabilité à des fonctions non continues. Elle
permet de considérer des cas limites sans avoir à les écrire explicitement,
tout en considérant les propriétés habituelles, opérateurs classiques
(dérivation, intégration, $*$, TL, TF...) définies pour des bonnes fonctions.**

La théorie des distributions donne un sens mathématique rigoureux à des objets
manipulés par des physiciens.

\newpage
## Distributions : définition et exemples

Soit $\mathcal{F}$ un ensemble de bonnes fonctions sur $\mathbb{R}$ vers
$\mathbb{R}$ ou $\mathbb{C}$.
$T$ est une fonctionnelle :
$$ T: \varphi\in\mathcal{F} \mapsto T(\varphi)=\langle T,\varphi\rangle
\in \mathbb{R}\text{ ou }\mathbb{C} $$

Afin d'avoir un ensemble de fonctionnelles larges, on impose des contraintes
fortes sur $\varphi$ que l'on appelle **fonction test**.

Dans la suite, on se limite à des fonctions $\varphi$ de $\mathbb{R}$
dans $\mathbb{R}$ ou $\mathbb{C}$.
Cependant une extension à des fonctions sur $\mathbb{R}^n$ est possible.

### Espace des fonctions test

**Espace des fonctions test** $\mathcal{D}$ :
ensemble des fonctions de $\mathbb{R}$ dans $\mathbb{R}$
ou $\mathbb{C}$, $C^{\infty}$ et à support borné.

**Support d'une fonction $\varphi$ réelle** :
le plus petit intervalle réel fermé en dehors duquel $\varphi$ est nul.

**Propriétés** :

 * $\mathcal{D}$ n'est pas vide (cf TD) ;
 * $(\mathcal{D}, +, \times)$ est un espace vectoriel ;
 * toutes les dérivées de $\varphi$ sont bornées, continues et intégrables ;
 * la limite vers $\pm\infty$ de $\varphi$ est nulle.

### Distributions

**Distribution** $T$ sur $\mathcal{D}$ :
une fonctionnelle **linéaire** et **continue** sur $\mathcal{D}$.
Notation : $T: \varphi\in\mathcal{D} \mapsto \langle T,\varphi\rangle$

On désigne par $\mathcal{D}'$ l'ensemble des distributions sur $\mathcal{D}$.
On dit encore que $\mathcal{D}'$ est l'espace dual de $\mathcal{D}$.

**Continuité** :
$\forall \{\varphi_n\}_{n\in\mathbb{N}} \in \mathcal{D}
\rightarrow^{\mathcal{D}} \varphi\in\mathcal{D}$
alors $\{\langle T,\varphi_n\rangle\}_{n\in\mathbb{N}}
\rightarrow \langle T,\varphi\rangle$.

### Convergence dans $\mathcal{D}$

**Définition** : une suite de fonction $\{\varphi_n\}_{n\in\mathbb{N}}$
de $\mathcal{D}$ CV dans $\mathcal{D}$ vers une fonction $\varphi$ de
$\mathcal{D}$ si :

 * les supports de $\varphi_n$ sont contenus dans un même ensemble borné
   indépendant de $n$.

 * $\forall k, \varphi_n^{(k)}$ CVU vers $\varphi^{(k)}$.

**Convergence simple** : voir web.

**Convergence uniforme** : voir web. Il faut que la fonction $\varphi$ soit
entourée d'un « tuyau » (flexible autour de $\varphi$) de taille $\epsilon$ dans
lequel les fonctions $\varphi_n$ doivent finir par entrer pour $n$ assez grand.

### Exemples

#### Distributions régulières

A toute fonction $f\in\mathcal{L}_{loc}^1$ on peut associer une distribution
$T_f\in\mathcal{D}'$ définie par :
$$ \forall \varphi\in\mathcal{D}, \langle T_f, \varphi\rangle
= \int_{-\infty}^{+\infty} f(x)\,\varphi(x)\,\mathrm{d}x
= \langle f, \varphi\rangle $$

Une telle distribution est dite **régulière**.

**Démo** : 

 * *Existence* : L'intégrale converge car $f\in\mathcal{L}_{loc}^1$.
 
 * *Linéarité* par la linéarité de l'intégrale.
 
 * *Continuité* : Soit $\{\varphi_n\}_{n\in\mathbb{N}}$ CVU vers $\varphi$.
   $|\langle T_f,\varphi_n \rangle - \langle T_f,\varphi \rangle |=...
    \leq \mathrm{sup} |\varphi_n(x)-\varphi(x)| \int_a^b |f|$ CV vers 0.

#### Distributions singulières de $D'$

C'est toutes les distributions de $D'$ qui ne sont pas régulières.

**Exemple 1** : La distribution de Dirac.
$$ \delta: \varphi\in\mathcal{D} \mapsto \langle\delta, \varphi\rangle
= \varphi(0) $$

**Démo** :

* *Existence* : $\varphi\in\mathcal{D}$ donc $\varphi(0)$ est fini.
* *Linéarité* : si on prend une somme pondérée de fonctions, on
  obtient la même somme pondérée à l'origine.
* *Continuité* : soit $\varphi_n$ qui tend vers $\varphi$. \newline
  $\langle\delta, \varphi_n\rangle=\varphi_n(0)$ tend vers
  $\varphi(0) = \langle\delta, \varphi\rangle$.

On symbolise le dirac sur un tracé par une flèche vers le haut à l'origine.

Il existe des distributions découlant de $\delta$.

**Exemple 2** : $\mathrm{vp}(\frac{1}{x})$. Voir le TD.

## Opérations élémentaires sur les distributions

### Addition et multiplication

Pour toute distributions $T_1$ et $T_2$ de $\mathcal{D}'$ et pour tout
$\alpha_1$ et $\alpha_2$ complexes ou réels.

$\forall \varphi\in\mathcal{D},
\langle \alpha_1 T_1 + \alpha_2 T_2, \varphi \rangle
= \alpha_1 \langle T_1, \varphi \rangle
+ \alpha_2 \langle T_2, \varphi \rangle$

Donc $T=\alpha_1 T_1 + \alpha_2 T_2$ est une fonctionnelle linéaire et continue.
Donc $T\in\mathcal{D}'$.

Donc **$(\mathcal{D}', +, \times)$ est un espace vectoriel**.
En réalité $\langle T, \varphi \rangle$ est une forme bilinéaire.

**La distribution nulle de $\mathcal{D}'$** : notée $T=0$.

**Égalité de deux distributions** :
$$ T_1=T_2 \iff T_1-T_2=0 \iff \forall \varphi,
\langle T_1-T_2,\varphi\rangle=0 $$

**Cas particulier** :
$T_1 = T_{f_1}$ et $T_2=T_{f_2}$ avec $f_1, f_2\in\mathcal{L}_{loc}^1$.
$\langle \alpha_1 T_1 + \alpha_2 T_2, \varphi \rangle
= \alpha_1 \langle Tf_1, \varphi \rangle + \alpha_2 \langle Tf_2, \varphi \rangle
= \int_{-\infty}^{+\infty} (\alpha_1 f_1(x)+\alpha_2 f_2(x))\varphi(x)\,\mathrm{d}x
= \langle T_{\alpha_1 f_1 + \alpha_2 f_2}, \varphi \rangle$

Donc :
$$ \alpha_1 T_1 + \alpha_2 T_2 = T_{\alpha_1 f_1 + \alpha_2 f_2} $$

### Translation

On définit $f_a$ la translaté de d'une fonction réelle $f$ de $a\in\mathbb{R}$.
$$ f_a: x \mapsto f_a(x) = f(x-a) $$

Pour une distribution :
$$ \forall\varphi\in\mathcal{D}, \langle T_a, \varphi \rangle
= \langle T, \varphi_{-a} \rangle $$

Pour une distribution régulière, on peut le montrer par un changement de
variable.

**Avec le Dirac** :
$\langle \delta_a, \varphi \rangle
= \langle \delta, \varphi_{-a} \rangle
= \varphi(a)$

Pour éviter les indices, on fait un abus de notation :
$$ \langle \delta(x-a), \varphi(x) \rangle = \varphi(a) $$

\def\peignedirac{%
\rule{1pt}{1.5ex}\rule{0.5em}{1pt}%
\rule{1pt}{1.5ex}\rule{0.5em}{1pt}\rule{1pt}{1.5ex}}

**Peigne de Dirac** : $\peignedirac = \sum_n \delta_n$

$\langle \peignedirac, \varphi \rangle = \sum_n \varphi(n)$ existe
car on somme un nombre fini de termes car $\varphi$ est à support borné.

**Distribution périodique** de période $a\in\mathbb{R}$ :
$T_a=T$.

### Retournement

On note $T_{-}$ la fonction retournée.

On montre que
$\forall\varphi\in\mathcal{D}, \langle T_{-},\varphi \rangle
= \langle T,\varphi_{-} \rangle$.

$T_{-}=T$ est **paire**, $T_{-}=-T$ est **impaire**.

### Conjugaison

À $T$ on associe la distribution conjuguée $T^*$.
$$\forall\varphi, \langle T^*, \varphi\rangle=\langle T, \varphi^*\rangle^* $$

### Dilatation

La dilatation de $f$ est $f_{(a)}:x\mapsto f(ax)$, avec $a\in\mathbb{R}^*$.

La dilatation de $T$ est $T_{(a)}$ tel que
$$\langle T_{(a)},\varphi\rangle =
\frac{1}{|a|}\langle T,\varphi_{(\frac{1}{a})}\rangle $$
ou encore
$$\langle T(ax),\varphi(x)\rangle =
\frac{1}{|a|}\left\langle T(x),\varphi\left(\frac{x}{a}\right)\right\rangle $$

**Avec le Dirac** :
$\delta(ax)=\frac{1}{|a|} \delta(x)$

### Produit

Si $f,g\in\mathcal{L}_{loc}^1$, 
$fg$ n'est pas nécessairement dans $\mathcal{L}_{loc}^1$.
Ainsi le produit peut ne pas exister.

Soit $\theta\in\mathcal{C}^{\infty}$.
$$ \langle\theta T, \varphi \rangle = \langle T, \theta\varphi \rangle $$
$\theta\varphi$ appartient à $\mathcal{D}$.
Donc $\theta T$ appartient à $\mathcal{D}'$.

**Cas particulier** :
$\theta(x)\delta(x)=\theta(0)\delta(x)$

**Remarque** : $xT(x)=0 \iff T=c\delta$ (cf TD)

On ne sait pas encore faire $u(x)\delta(x)$ car l'échelon n'est pas
$C^{\infty}$.

### Convergence dans $\mathcal{D}'$

**Définition** : Une suite de distributions $\{T_n\}_{n\in\mathbb{N}}$
de $\mathcal{D}'$ converge dans $\mathcal{D}'$ si
$\forall\varphi\in\mathcal{D}, {\langle T_n, \varphi\rangle}_n$ CV.

On note $\langle T, \varphi\rangle$ cette limite.
On montre que $T$ appartient à $\mathcal{D}'$ (hors programme).

On note $\langle T_n, \varphi\rangle \rightarrow^{D'}_{n\rightarrow\infty}
\langle T, \varphi\rangle$
ou $\mathrm{lim}_{n\rightarrow\infty} T_n =^{D'} T$.

## Dérivation des distributions

La propriété essentielle des distributions est qu'elles sont indéfiniment
dérivables et que toutes les dérivés sont des distributions.
Ce qui rend l'utilisation des distributions très commode.

### Définition et propriétés

$T \rightarrow T^{(n)}$ est la dérivée n-ième de la distribution $T$.

$\langle T', \varphi \rangle = -\langle T, \varphi'\rangle$ donc
$\langle T^{(n)}, \varphi\rangle = (-1)^n \langle T, \varphi^{(n)}\rangle$

**Propriété** : $\forall\theta$ de classe $C^\infty,
(\theta T)' = \theta' T + \theta T'$.

**Démonstration** :
$\langle (\theta T)',\varphi\rangle
= -\langle\theta T,\varphi'\rangle$\newline
$= -\langle T,\theta\varphi'\rangle
= -\langle T,(\theta\varphi)'-\theta'\varphi\rangle
= \langle \theta T' + \theta' T,\varphi\rangle$

**Primitive** : $T$ est une primitive de $S$ $\iff T'=S$.

### Exemples

Soit $f\in\mathcal{L}_{loc}^1$
telle que $f$ soit dérivable et $f'\in\mathcal{L}_{loc}^1$
et $T_f=f$ la distribution associée.

Par une intégration par parties,
$$ \forall\varphi\in\mathcal{D}, \langle T_f',\varphi \rangle
= -\langle T_f, \varphi'\rangle
= \langle T_{f'},\varphi\rangle $$

#### Dérivée de l'échelon d'Heaviside

L'échelon d'Heaviside $u$ est localement sommable.
$$ \forall\varphi,
\langle T_{u'},\varphi\rangle
= -\langle T_u,\varphi'\rangle
= \varphi(0)
= \langle\delta, \varphi\rangle $$

### Dérivée de la distribution de Dirac

$\langle\delta', \varphi\rangle
= -\langle\delta, \varphi'\rangle
= -\varphi'(0)$

En généralisant :
$\langle\delta^{(k)}, \varphi\rangle
= (-1)^k \varphi^{(k)}(0)$

Étude de $x\delta'=T_x \delta'$. Cette fonction est localement sommable car $x$
est $C^{\infty}$.
$$\langle x\delta',\varphi\rangle=-\varphi(0)=-\langle \delta,\varphi\rangle$$

### Convergence dans $\mathcal{D}'$ et dérivation

Soit $\{T_n\}_n$ qui tend vers $T$.
Alors $\{T_n^{(k)}\}_n$ tend vers $T^{(k)}$,
on peut permuter limite et dérivation avec
les distributions plus simplement qu'avec les fonctions.

**Démonstration** :
$-\langle T_n',\varphi\rangle
= \langle T_n,\varphi'\rangle$
tend vers
$\langle T,\varphi'\rangle
= -\langle T',\varphi\rangle$
Donc $\{T_n\}_n$ tend vers $T$.

### Dérivée d'une fonction discontinue

Soit $f$ une fonction continue et dérivable sauf en $x=x_0$ avec une
discontinuité de première espèce (par exemple continue sauf en un point où elle
n'est continue qu'à droite).

$f'$ existe sauf en $x_0$. $T_{\{f'\}}$ est la distribution associée à $f'$ au
sens classique des fonctions. La hauteur de la discontinuité est $\sigma_0$.

En découpant l'intervalle d'intégration,
$$ \langle (T_f)', \varphi \rangle = ... = \langle T_{\{f'\}}, \varphi \rangle
+ \sigma_0 \langle \delta_{x_0}, \varphi \rangle $$

Donc $f'=\{f'\} + \sigma_0 \delta_{x_0}$.

On peut ajouter plus de dirac pour généraliser.

\newpage
## Convolution

### Convolution de fonctions

Voir TD

### Convolution de deux distributions

**Définition** : sous réserve d'existence, le produit de convolution de deux
distributions S et T, noté $S*T$, est défini par :
$$ \forall\varphi\in\mathcal{D}, \langle S*T, \varphi\rangle
= \left\langle S, \langle T, \varphi_{-x}\rangle\right\rangle $$

On note aussi $\langle S(x)\,T(y), \varphi(x+y)\rangle_{\mathbb{R}^2}$.

On utilise le théorème de Fubini pour montrer que $T_f*T_g=T_{f*g}$.

### Existence

**Support d'une distribution** :

Soit $\omega$ un ensemble ouvert de R. On dit que T est nulle sur
$\omega$, si $\varphi\in\mathcal{D}$ ayant son support contenu dans $\omega$, on
$\langle T,\varphi\rangle=0$.

Le support de $T$ est le complémentaire de la réunion de tous les ouverts sur
lesquels la distribution $T$ est nulle. Le support est fermé.

**Conditions d'existence** :

Même si $\varphi(x)$ est à support borné dans R, $\varphi(x+y)$ n'est pas pour
autant à support borné dans $\mathbb{R}^2$. Cette fonction est dans une bande.

$S*T$ n'existe pas nécessairement. Si $S$ et $T$ sont telles que $(x+y)$ bornée
entraîne $x$ et $y$ bornées alors le produit de convolution existe.

### Propriétés

**Commutatif** : $S*T=T*S$.

**Linéaire** : par la linéarité de la distribution.

$\delta$ est **l'élément neutre** du produit de convolution.

#### Associativité

Si les 3 produits $R*S$, $S*T$ et $R*T$ existent, alors $R*S*T$ existe et
$$ R*S*T = S*(R*T) = (R*S)*T = R*(S*T) $$

Si les 3 produits ne sont pas définis, alors dans ça peut ne pas être vrai.

#### Continuité

Soit $\{T_n\}_n$ une suite de distributions de $\mathcal{D}'$ convergeant vers
$T\in\mathcal{D}'$ ayant toutes leur support contenu dans un même ensemble borné
et telles que $S*T_n$ existe pour tout $n$. Alors $S*T_n$ tend vers $S*T$.

#### Algèbre de convolution

**Définition** : 
tout espace vectoriel de distribution contenant $\delta$ et sur lequel on peut
définir le produit de convolution d'un nombre fini quelconque de distributions.

**Exemples** :

 * Distributions à support borné $\mathcal{E}'$
 * Distributions à support borné à gauche $\mathcal{D}'_+$
 * Distributions à support borné à droite $\mathcal{D}'_-$

Les algèbres de convolution permettent de résoudre des équations du type
$A*X=B$.

Sous réserve d'existence, on note $A^{*-1}$ l'inverse de convolution de $A$ :
$$ A * A^{*-1} = \delta $$

Pour que l'équation de convolution ait toujours au moins une solution dans une
algèbre de convolution, il faut et il suffit que $A$ possède un inverse
$A^{*-1}$ dans l'algèbre.

Dans ce cas $A^{*-1}$ est unique et la solution unique est donnée :
$$ X = A^{*-1}*B = B*A^{*-1} $$
(sinon la solution peut ne pas exister ou seulement pour certains $B$)

## Transformée de Fourier

L'idée est de reporter la TF de la distribution sur la fonction sur laquelle la
distribution agit : $\langle TF[T], \varphi\rangle$ vers
$\langle T, TF[\varphi] \rangle$,
tout en ayant une définition qui soit valable pour $T$ associé à une bonne
fonction.

### TF des fonctions

Soit $f$ une fonction sur $\mathbb{R}$, à valeurs dans
$\mathbb{R}$ ou $\mathbb{C}$, sous réserve d'existence, la TF est définie par :
$$ TF[f(x)] = \tilde{f}(V)=\int_{-\infty}^{+\infty} f(x) e^{-j2\pi V x}\,dx $$

**Remarques** :

 * si $f\in\mathcal{L}^1$ alors la TF existe,
 * si $f\in\mathcal{L}^2$ alors la TF existe et $\tilde{f}\in\mathcal{L}^2$,
 * si $f\in\mathcal{D}$, on est amené à considérer un espace de fonction test
   moins restrictif que $\mathcal{D}$ et tel que la TF de toute fonction de cet
   espace soit encore dans cet espace : stabilité par TF.

**Inversion** :
$$TF^{-1}[\tilde\varphi(V)] = \int\tilde\varphi(V)e^{j2\pi V x}\,dV=\varphi(x)$$

### Espace de Schwartz

**Espace de Schwartz** $\mathcal{S}$ :
l'ensemble des fonctions sur $\mathbb{R}$ à valeurs
dans $\mathbb{R}$ ou $\mathbb{C}$ de classe $C^{\infty}$,
décroissant à l'infini, ainsi que toutes leurs dérivées,
plus vite que toute puissance de $\frac{1}{|x|}$.
$$\forall k\in\mathbb{N}, \forall l\in\mathbb{n}, |x|^l |\varphi^k(x)|
\rightarrow 0$$

On a $\mathcal{D}\subset\mathcal{S}$.

On montre que si $\varphi\in\mathcal{S}$ alors
$TF[\varphi]=\tilde\varphi$
existe et est dans $\mathcal{S}$ (stabilité par TF).

### Convergence dans $\mathcal{S}$

**Déf** : une suite de fonctions $\{\varphi_n\}_n$ de $\mathcal{S}$ converge
dans $\mathcal{S}$ vers une fonction $\varphi$ de $\mathcal{S}$ si
$$ \forall k \in\mathbb{N}, \forall l \in\mathbb{N}, x^l \varphi^{(k)}_n(x)
\rightarrow x^l \varphi^{(k)}(x) $$

On démontre que la TF est un opérateur linéaire et continu de $\mathcal{S}$ dans
$\mathcal{S}$.

**Remarque** : si $\varphi\in\mathcal{S}$ alors $\varphi'\in\mathcal{S}$.

### Distributions tempérées

**Définition** : une distribution tempérée est une fonctionnelle linéaire
et continue sur $\mathcal{S}$.

$\mathcal{S}'$ est ensemble de toutes les distributions sur $\mathcal{S}$
c'est-à-dire le dual de $\mathcal{S}$.

$$ \mathcal{D}  \subset \mathcal{S}  \subset \mathcal{E}  $$
$$ \mathcal{E}' \subset \mathcal{S}' \subset \mathcal{D}' $$

### TF des distributions tempérées

$\langle TF[T], \varphi \rangle = \langle T, TF[\varphi] \rangle$
et\newline
$\langle TF^{-1}[T], \varphi \rangle = \langle T, TF^{-1}[\varphi] \rangle$

**Cas particulier important** : si $T$ est à support borné
$T\in\mathcal{E}'\subset \mathcal{S}'$
alors $TF[T]=\langle T(x), e^{j2\pi V x}\rangle$

**Démo** :
$\langle\tilde T_f, \varphi\rangle
= \int f(x) \int \varphi(V) e^{-j 2\pi V x}\,dV\,dx
= \int \varphi(V) \int f(x) ... \,dx\,dV
= \langle T_{\tilde f}, \varphi \rangle$

## Transformée de Laplace

### TL des fonctions

Limite de la TF : pour que la TF existe il faut que cette fonction décroisse
assez vite en $\pm\infty$.
Idée : multiplier $f(x)$ par $e^{-\sigma x}$ pour forcer la décroissance.
$$TL[f(x)]=TF[f(x)e^{-\sigma x}]=\hat f(x)$$

Rq : si $f$ est à support borné à gauche alors $]\sigma_{min}, +\infty[$.

### TL des distributions

On se limite aux distributions à support borné à gauche ($\mathcal{D}'_+$).

**Définition** : $\forall T\in\mathcal{D}'_+, TL[T]=\langle T(x), e^{-px}\rangle
= \hat T(p)$
avec $p=\sigma+j2\pi V$.



